/*
 * Decompiled with CFR 0.152.
 */
package com.pancake.campfire_resting.client.gui;

import com.pancake.campfire_resting.CampfireResting;
import com.pancake.campfire_resting.Time;
import com.pancake.campfire_resting.capability.RestingCap;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CampfireGUIScreen
extends Screen {
    private static final ResourceLocation DUSK = CampfireResting.asResource("textures/gui/dusk.png");
    private static final ResourceLocation EARLY_MORNING = CampfireResting.asResource("textures/gui/early_morning.png");
    private static final ResourceLocation MIDNIGHT = CampfireResting.asResource("textures/gui/midnight.png");
    private static final ResourceLocation NOON = CampfireResting.asResource("textures/gui/noon.png");
    private final BlockPos pos;
    private ImageButton dusk;
    private ImageButton early_morning;
    private ImageButton midnight;
    private ImageButton noon;
    private int select;

    public CampfireGUIScreen(BlockPos pos) {
        super((Component)Component.m_237115_((String)"gui.campfire_resting.rest"));
        this.pos = pos;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        this.dusk.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.early_morning.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.midnight.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.noon.m_88315_(graphics, mouseX, mouseY, partialTicks);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    protected void m_7856_() {
        ImageButton early_morning = new ImageButton(this.f_96543_ / 2 - 100, this.f_96544_ / 2 - 30, 40, 40, 0, 0, 40, EARLY_MORNING, 40, 80, onPress -> {
            this.select = 1;
        }, (Component)Component.m_237115_((String)"gui.campfire_resting.early_morningzg"));
        ImageButton noon = new ImageButton(this.f_96543_ / 2 - 40, this.f_96544_ / 2 - 30, 40, 40, 0, 0, 40, NOON, 40, 80, onPress -> {
            this.select = 2;
        }, (Component)Component.m_237115_((String)"gui.campfire_resting.noon"));
        ImageButton dusk = new ImageButton(this.f_96543_ / 2 + 20, this.f_96544_ / 2 - 30, 40, 40, 0, 0, 40, DUSK, 40, 80, onPress -> {
            this.select = 3;
        }, (Component)Component.m_237115_((String)"gui.campfire_resting.dusk"));
        ImageButton midnight = new ImageButton(this.f_96543_ / 2 + 80, this.f_96544_ / 2 - 30, 40, 40, 0, 0, 40, MIDNIGHT, 40, 80, onPress -> {
            this.select = 4;
        }, (Component)Component.m_237115_((String)"gui.campfire_resting.midnight"));
        this.dusk = (ImageButton)this.m_142416_((GuiEventListener)dusk);
        this.early_morning = (ImageButton)this.m_142416_((GuiEventListener)early_morning);
        this.midnight = (ImageButton)this.m_142416_((GuiEventListener)midnight);
        this.noon = (ImageButton)this.m_142416_((GuiEventListener)noon);
        super.m_7856_();
    }

    public void m_7379_() {
        ClientLevel level = this.f_96541_.f_91073_;
        if (level != null && this.isPlayerNearby((Level)level, this.pos)) {
            RestingCap.get((Level)level).ifPresent(restingCap -> {
                int skipTime = this.getSkipTime((Level)level, this.select);
                restingCap.setSkipTime(skipTime);
                restingCap.setResting(true);
            });
        }
        super.m_7379_();
    }

    private boolean isPlayerNearby(Level level, BlockPos pos) {
        return level.m_45976_(Player.class, new AABB(pos).m_82377_(8.0, 8.0, 8.0)).stream().filter(player -> !player.m_5833_()).count() > (long)(level.m_6907_().size() / 2);
    }

    public int getSkipTime(Level level, int select) {
        long dayTime = level.m_46468_() % 24000L;
        Time[] times = new Time[]{Time.EARLY_MORNING, Time.NOON, Time.DUSK, Time.MIDNIGHT};
        if (select >= 1 && select <= times.length) {
            Time selectedTime = times[select - 1];
            if (dayTime < (long)selectedTime.getTime()) {
                return (int)((long)selectedTime.getTime() - dayTime);
            }
            return (int)(24000L - dayTime + (long)selectedTime.getTime());
        }
        return 0;
    }
}

